% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probcube.R
\name{probcube}
\alias{probcube}
\title{Probability distribution of a CUBE model without covariates}
\usage{
probcube(m,pai,csi,phi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}

\item{phi}{Overdispersion parameter}
}
\value{
The vector of the probability distribution of a CUBE model without covariates.
}
\description{
Compute the probability distribution of a CUBE model without covariates.
}
\examples{
m<-9
pai<-0.3
csi<-0.8
phi<-0.1
pr<-probcube(m,pai,csi,phi)
plot(1:m,pr,type="h", main="CUBE probability distribution",xlab="Ordinal categories")
points(1:m,pr,pch=19)
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data,
\emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786
}
\seealso{
\code{\link{betar}}, \code{\link{betabinomial}}
}
\keyword{distribution}
