% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singularity_generation.R
\name{generate_singularity}
\alias{generate_singularity}
\title{Generate Singularity Definition File}
\usage{
generate_singularity(
  output_dir,
  r_version = NULL,
  base_image = "rocker/r-ver",
  conda_env = NULL,
  system_deps = NULL,
  project_name = "reproflow-project"
)
}
\arguments{
\item{output_dir}{Character. Directory to save Singularity files (required).}

\item{r_version}{Character. R version to use. Default is current R version.}

\item{base_image}{Character. Base Docker image. Default "rocker/r-ver"}

\item{conda_env}{Character. Path to conda environment file. Optional.}

\item{system_deps}{Character vector. System dependencies to install}

\item{project_name}{Character. Name for the project}
}
\value{
List of generated file paths
}
\description{
Generate a Singularity/Apptainer definition file for HPC environments.
Singularity is commonly used in HPC clusters where Docker is not available.
}
\examples{
\dontrun{
generate_singularity(
  output_dir = tempdir(),
  project_name = "my_analysis",
  system_deps = c("samtools", "bwa")
)
}
}
