% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_it.R
\name{trim_it}
\alias{trim_it}
\title{Trim a data frame or an S3 object}
\usage{
trim_it(data_obj, trim_quantiles, variable)
}
\arguments{
\item{data_obj}{A data frame or an S3 object containing the data to be
trimmed. For a data frame, the function operates directly on it. For an S3
object, the function expects a \code{.data} attribute containing the data.}

\item{trim_quantiles}{A numeric vector of length 2 specifying the lower and
upper quantiles used for trimming the data.}

\item{variable}{The name of the variable in the data on which the trimming is
to be applied.}
}
\value{
Returns a trimmed data frame or an S3 object with the $.data attribute
trimmed, depending on the input type.
}
\description{
Trims a data frame or an S3 object's \code{.data} attributs.
}
\examples{

# Example usage with a data frame
df <- data.frame(id = 1:10, value = rnorm(100))
trimmed_df <- trim_it(df, c(0.1, 0.9), "value")

# Example usage with an S3 object
data_obj <- list()
class(data_obj) <- "myobject"
data_obj$.data <- df
trimmed_data_obj <- trim_it(data_obj, c(0.1, 0.9), "value")

}
