% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Dosepoint.R
\name{list_Dosepoints}
\alias{list_Dosepoints}
\title{List Dosepoints in the current PML set}
\usage{
list_Dosepoints(PMLParametersSets, IncludeAll = FALSE, IncludeCustom = TRUE)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{IncludeAll}{Logical. Should the names of dosepoints with \code{None} state
be included or not. Default is \code{FALSE}.}

\item{IncludeCustom}{Logical. Should the names of custom \code{dosepoint} and
\code{dosepoint2} statements (from the PML code of custom spaces) be included or
not. Default is \code{TRUE}.}
}
\value{
A character vector containing the names of dosepoints
}
\description{
This function lists the names of dosepoints in a given set of
PMLParametersSets.
}
\examples{
PMLParametersSets <-
  get_PMLParametersSets(
    Absorption = c("First-Order", "Gamma"))
list_Dosepoints(PMLParametersSets)

}
\seealso{
\code{\link[=modify_Dosepoint]{modify_Dosepoint()}}
}
