#' Access NLME model overall fit results
#'
#' @description Access model fit diagnostics from an xpdb object generated by
#' xposeNlme.
#'
#' @param xpdb An \code{xpose} data base object from which the model output file data
#'  will be extracted. Only objects generated by \code{xposeNlme} are supported.
#' @param .problem The problem to be used.
#' @param .subprob The subproblem to be used.
#' @param .method The estimation method to be used.
#'
#' @return A tibble for single problem/subproblem.
#' @seealso \code{\link{xposeNlme}}
#' @importFrom magrittr %>%
#' @examples
#' # Store the parameter table
#' prmOverall <- get_overallNlme(xpdb_ex_Nlme)
#'
#' @export
get_overallNlme <- function(xpdb,
                            .problem = 1,
                            .subprob = 0,
                            .method = NULL) {
  stopifnot(xpose::is.xpdb(xpdb))
  prmOverall <- xpdb$files %>%
    dplyr::filter(name == "Overall" &
      problem == get(".problem") &
      subprob == get(".subprob"))

  if (!is.null(.method)) {
    prmOverall <-
      dplyr::filter(prmOverall, problem == get(".method"))
  }

  if (nrow(prmOverall) == 0) {
    stop("Data frame with given properties is not found in the database.")
  } else if (nrow(prmOverall) > 1) {
    warning("More than one data frame is found with given condition;
            using the last one.")
    prmOverall <- prmOverall[nrow(prmOverall), ]
  }

  prmOverall$data[[1]]
}
