% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggNlme.R
\name{nlme.var.vs.cov}
\alias{nlme.var.vs.cov}
\title{Build multiple plots for selected variable vs covariates}
\usage{
nlme.var.vs.cov(xpdb, covColNames, nrow = 1, ncol = 1, yVar = "WRES", ...)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{covColNames}{Character vector of covariates to build the matrix.}

\item{nrow}{Number of rows.}

\item{ncol}{Number of columns; if ncol=1, each gtable object is treated separately.}

\item{yVar}{Variable from xpdb data to build a plot.}

\item{...}{Parameters to be passed to \code{\link[egg]{ggarrange}()}}
}
\value{
List of \code{\link[gtable]{gtable}}
}
\description{
The type of plot depends on the type of covariate: boxplot for categorical,
geom_point and geom_smooth for continuous.
}
\examples{
nlme.var.vs.cov(
  xpdb = xpdb_ex_Nlme,
  covColNames = c("sex", "wt", "age"),
  yVar = "WRES",
  nrow = 2,
  ncol = 2
  )
}
