% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformat_marker_data.R
\name{reformat_marker_data}
\alias{reformat_marker_data}
\title{reformat and Sort Marker Data for All Time Frames}
\usage{
reformat_marker_data(data, convert_to_cm = TRUE)
}
\arguments{
\item{data}{A data frame containing marker coordinate data for all time frames.
Columns should be named in the format 'MXX X', 'MXX Y', 'MXX Z' where 'MXX' is the marker name.}

\item{convert_to_cm}{Logical, if TRUE, divides X, Y, Z coordinates by 10 to convert to centimeters (from millimeters).}
}
\value{
A data frame with columns 'Timeframe', 'Marker', 'X', 'Y', 'Z', sorted by Timeframe and Marker.
}
\description{
reformat the input dataset by sorting marker columns based on marker names
and reformats it into a long format with columns 'Timeframe', 'Marker', 'X', 'Y', 'Z'.
Adds a Timeframe column corresponding to each row (time frame) in the original data.
}
\details{
The function reshapes the wide-format data into a long format suitable for analysis,
adding a Timeframe column that corresponds to each time frame. Optionally converts units to centimeters.
}
\examples{
data(sample_data)
reformat_data <- reformat_marker_data(head(sample_data), convert_to_cm = TRUE)
head(reformat_data)

}
