% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{dWishart}
\alias{dWishart}
\alias{dInvWishart}
\title{Density for Random Wishart Distributed Matrices}
\usage{
dWishart(x, df, Sigma, log = TRUE)

dInvWishart(x, df, Sigma, log = TRUE)
}
\arguments{
\item{x}{positive definite \eqn{p \times p}{p * p} observations for density
estimation - either one matrix or a 3-D array.}

\item{df}{numeric parameter, "degrees of freedom".}

\item{Sigma}{positive definite \eqn{p \times p}{p * p} "scale" matrix,
the matrix parameter of the distribution.}

\item{log}{logical, whether to return value on the log scale.}
}
\value{
Density or log of density
}
\description{
Compute the density of an observation of a random Wishart distributed matrix
(\code{dWishart}) or an observation
from the inverse Wishart distribution (\code{dInvWishart}).
}
\details{
Note there are different ways of parameterizing the Inverse
   Wishart distribution, so check which one you need.
    Here,  If \eqn{X \sim IW_p(\Sigma, \nu)}{X ~ IW_p(Sigma, df)} then
    \eqn{X^{-1} \sim W_p(\Sigma^{-1}, \nu)}{X^{-1} ~ W_p(Sigma^{-1}, df)}.
    Dawid (1981) has a different definition: if
    \eqn{X \sim W_p(\Sigma^{-1}, \nu)}{X ~ W_p(Sigma^{-1}, df)} and
    \eqn{\nu > p - 1}{df > p - 1}, then
    \eqn{X^{-1} = Y \sim IW(\Sigma, \delta)}{X^{-1} = Y ~ IW(Sigma, delta)},
    where
    \eqn{\delta = \nu - p + 1}{delta = df - p + 1}.
}
\section{Functions}{
\itemize{
\item \code{dInvWishart()}: density for the inverse Wishart distribution.

}}
\examples{
set.seed(20180222)
A <- rWishart(1, 10, diag(4))[, , 1]
A
dWishart(x = A, df = 10, Sigma = diag(4L), log = TRUE)
dInvWishart(x = solve(A), df = 10, Sigma = diag(4L), log = TRUE)
}
\references{
Dawid, A. (1981). Some Matrix-Variate Distribution Theory:
Notational Considerations and a Bayesian Application.
\emph{Biometrika}, 68(1), 265-274. \doi{10.2307/2335827}

Gupta, A. K.  and D. K. Nagar (1999). \emph{Matrix variate distributions}.
Chapman and Hall.

Mardia, K. V., J. T. Kent, and J. M. Bibby (1979)
\emph{Multivariate Analysis},
London: Academic Press.
}
