nntsmeasureslocationdispersion<-function(cestimates,M=0){

  firstmoment<-0+0i

  for (k in 1:M){
    firstmoment<-firstmoment+(2*pi)*cestimates[k,2]*Conj(cestimates[k+1,2])
  }

  secondmoment<-0+0i

  if (M>1){
    for (k in 1:(M-1)){
      secondmoment<-secondmoment+(2*pi)*cestimates[k,2]*Conj(cestimates[k+2,2])
    }
    secondmoment<-exp(-2i*Arg(firstmoment))*secondmoment
  }

  meandirection<-Arg(firstmoment)
  dispersion<-Mod(firstmoment)
  circularvariance<-1-dispersion
  asymmetry<-Im(secondmoment)/(circularvariance^(3/2))
  kurtosis<-(Re(secondmoment)-dispersion^4)/(circularvariance^2)

  res<-list()

  res["firstmoment"]<-firstmoment
  res["secondmoment"]<-secondmoment
  res["meandirection"]<-meandirection
  res["dispersion"]<-dispersion
  res["circularvariance"]<-circularvariance
  res["asymmetrycoefficient"]<-asymmetry
  res["kurtosis"]<-kurtosis

  res
}
