/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCorelatedCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Execution;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ObservationPeriod;
import org.ohdsi.circe.cohortdefinition.PayerPlanPeriod;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;

public class FirstTimeInHistoryCheck
extends BaseCorelatedCriteriaCheck {
    private static final String WARNING = "%s didn't specify that it must be first time in patient's history";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.INFO;
    }

    @Override
    protected void checkCriteria(CorelatedCriteria criteria, String groupName, WarningReporter reporter) {
        String name = CriteriaNameHelper.getCriteriaName(criteria.criteria) + " at " + groupName;
        Execution addWarning = () -> reporter.add(WARNING, name);
        Operations.match(criteria).when(c -> c.startWindow != null && (c.startWindow.start != null && c.startWindow.start.days != null || c.startWindow.end != null && c.startWindow.end.days != null)).then(cc -> Operations.match(cc.criteria).isA(ConditionEra.class).then(c -> Operations.match((ConditionEra)c).when(conditionEra -> Objects.isNull(conditionEra.first)).then(addWarning)).isA(ConditionOccurrence.class).then(c -> Operations.match((ConditionOccurrence)c).when(conditionOccurrence -> Objects.isNull(conditionOccurrence.first)).then(addWarning)).isA(DeviceExposure.class).then(c -> Operations.match((DeviceExposure)c).when(deviceExposure -> Objects.isNull(deviceExposure.first)).then(addWarning)).isA(DoseEra.class).then(c -> Operations.match((DoseEra)c).when(doseEra -> Objects.isNull(doseEra.first)).then(addWarning)).isA(DrugEra.class).then(c -> Operations.match((DrugEra)c).when(drugEra -> Objects.isNull(drugEra.first)).then(addWarning)).isA(DrugExposure.class).then(c -> Operations.match((DrugExposure)c).when(drugExposure -> Objects.isNull(drugExposure.first)).then(addWarning)).isA(Measurement.class).then(c -> Operations.match((Measurement)c).when(measurement -> Objects.isNull(measurement.first)).then(addWarning)).isA(Observation.class).then(c -> Operations.match((Observation)c).when(observation -> Objects.isNull(observation.first)).then(addWarning)).isA(ObservationPeriod.class).then(c -> Operations.match((ObservationPeriod)c).when(observationPeriod -> Objects.isNull(observationPeriod.first)).then(addWarning)).isA(ProcedureOccurrence.class).then(c -> Operations.match((ProcedureOccurrence)c).when(procedureOccurrence -> Objects.isNull(procedureOccurrence.first)).then(addWarning)).isA(Specimen.class).then(c -> Operations.match((Specimen)c).when(specimen -> Objects.isNull(specimen.first)).then(addWarning)).isA(VisitOccurrence.class).then(c -> Operations.match((VisitOccurrence)c).when(visitOccurrence -> Objects.isNull(visitOccurrence.first)).then(addWarning)).isA(VisitDetail.class).then(c -> Operations.match((VisitDetail)c).when(visitDetail -> Objects.isNull(visitDetail.first)).then(addWarning)).isA(PayerPlanPeriod.class).then(c -> Operations.match((PayerPlanPeriod)c).when(payerPlanPeriod -> Objects.isNull(payerPlanPeriod.first)).then(addWarning)));
    }
}

