% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_MPD.R
\name{calculate_MPD}
\alias{calculate_MPD}
\title{Calculate mean pairwise distances}
\usage{
calculate_MPD(distances, taxon_groups)
}
\arguments{
\item{distances}{An object of class \code{distanceMatrices}.}

\item{taxon_groups}{An object of class \code{taxonGroups}.}
}
\value{
A labelled vector of weighted mean pairwise distances.
}
\description{
Given distanceMatrices and taxonGroups objects calculates their mean pairwise distances.
}
\details{
Not all measures of disparity (morphological distance) require an ordination space. For example, the pariwise distances between taxa are themselves a disparity metric. This function takes the output from \link{calculate_morphological_distances} and a set of taxon groups and returns the mean pairwise distance for each of those groups.
}
\examples{

# Get morphological distances for the Day et al. (2016) data set:
distances <- calculate_morphological_distances(
  cladistic_matrix = day_2016,
  distance_metric = "mord",
  distance_transformation = "none"
)

# Build simple taxonomic groups for Day et al. (2016) data set:
taxon_groups <- list(nonBurnetiamorpha = c("Biarmosuchus_tener", "Hipposaurus_boonstrai",
  "Bullacephalus_jacksoni", "Pachydectes_elsi", "Niuksenitia_sukhonensis", "Ictidorhinus_martinsi",
  "RC_20", "Herpetoskylax_hopsoni"), Burnetiamorpha = c("Lemurosaurus_pricei", "Lobalopex_mordax",
  "Lophorhinus_willodenensis", "Proburnetia_viatkensis", "Lende_chiweta",
  "Paraburnetia_sneeubergensis", "Burnetia_mirabilis", "BP_1_7098"))

# Set class as taxonGroups:
class(taxon_groups) <- "taxonGroups"

# Calculate mean pairwise distances:
calculate_MPD(distances, taxon_groups)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
