% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_cherries.R
\name{count_cherries}
\alias{count_cherries}
\title{Counts the number of cherries in a tree}
\usage{
count_cherries(tree)
}
\arguments{
\item{tree}{A tree (phylo or multiPhylo object).}
}
\value{
Returns a vector of cherry counts for each tree retaining the order in which they were supplied.
}
\description{
Given a set of phylogenetic tree(s) returns the number of cherries in each one.
}
\details{
Cherries are components of a phylogenetic tree defined as internal nodes with exactly two terminal descendants.

This function simply counts the number present in a given tree.

Note that any fully dichotomous phylogenetic tree must have at least one cherry.
}
\examples{

# Create simple two-cherry tree:
tree <- ape::read.tree(text = "((A,B),(C,D));")

# Show count of cherries is two:
count_cherries(tree = tree)

# Create a star tree:
tree <- ape::read.tree(text = "(A,B,C,D);")

# Show count of cherries is zero:
count_cherries(tree = tree)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
