% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_costmatrices.r
\name{permute_costmatrices}
\alias{permute_costmatrices}
\title{Permute costmatrices}
\usage{
permute_costmatrices(states = c("0", "1"), costs = c(1:3), symmetry = "both")
}
\arguments{
\item{states}{A vector of character states, e.g., "0", "1", "2".}

\item{costs}{A vector of numeric costs, e.g., 1, 2, Inf.}

\item{symmetry}{Must be one of \code{"symmetric"}, \code{"asymmetric"} or \code{"both"}.}
}
\value{
A list of unique costmatrices containing every possible combination of costs.
}
\description{
Given vectors of states and costs, permutes all possible costmatrices.
}
\details{
Costmatrices define the cost of each state-to-state transition, but they are restricted in what these costs can be (see \link{check_costMatrix}). Nevertheless, strictly speaking there are infinite possible costmatrices - even where costs are restricted to integer values (as TNT does; Goloboff et al. 2008; Goloboff and Catalano 2016), i.e., "stepmatrices" (Swofford and Maddison 1992). Thus this function operates on a finite system by requiring the user to specify a restricted set of states and individual cost values, with the function permuting every possible combination of finite costs. Note that not \emph{every} permutation will be returned as not all of these will be valid costmatrices (see \link{check_costMatrix} and \link{fix_costmatrix}). Others will not be returned because their cost \emph{ratio} can be considered redundant. For example, for a binary character (states "0", and "1") the following two costmatrices would be mutually redundant as the ratio of their costs is identical:

\preformatted{  A B
A 0 1
B 2 0

  A B
A 0 2
B 4 0}

(If the user does want to consider these kinds of alternatives then a better solution is to simply weight the first matrix by two, or any other value, in any downstream analys(es).)

For the function to work costs must be unique positive values. This includes infinity (\code{Inf} in R). Infinite costs can be used to denote a particular transition is impossible and allows defining (e.g.) irreversible characters, or those that force a particular root value.
}
\examples{

# Permute all the ways to assign the costs 1 and 2 for a three state
# character:
permute_costmatrices(
  states = c("0", "1", "2"),
  costs = c(1, 2),
  symmetry = "both"
)

}
\references{
Goloboff, P. A. and Catalano, S. A., 2016. TNT version 1.5, including a full implementation of phylogenetic morphometrics/ \emph{Cladistics}, \bold{32}. 221-238

Goloboff, P., Farris, J. and Nixon, K., 2008. TNT, a free program for phylogenetic analysis. \emph{Cladistics}, \bold{24}, 774-786.

Swofford, D. L. and Maddison, W. P., 1992. Parsimony, character-state reconstructions, and evolutionary inferences. \emph{In} R. L. Mayden (ed.) Systematics, Historical Ecology, and North American Freshwater Fishes. Stanford University Press, Stanford, p187-223.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
