% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_nexus_matrix.R
\name{write_nexus_matrix}
\alias{write_nexus_matrix}
\title{Writes out a morphological #NEXUS data file}
\usage{
write_nexus_matrix(cladistic_matrix, file_name)
}
\arguments{
\item{cladistic_matrix}{The cladistic matrix in the format imported by \link{read_nexus_matrix}.}

\item{file_name}{The file name to write to. Should end in \code{.nex}.}
}
\description{
Writes out a morphological data file in #NEXUS format.
}
\details{
Writes out a #NEXUS (Maddison et al. 1997) data file representing the distribution of characters in a set of taxa. Data must be in the format created by importing data with \link{read_nexus_matrix}.
}
\examples{

# Write out Michaux 1989 to current working directory:
write_nexus_matrix(cladistic_matrix = michaux_1989, file_name = "michaux_1989.nex")

# Remove file when finished:
file.remove(file1 = "michaux_1989.nex")
}
\references{
Maddison, D. R., Swofford, D. L. and Maddison, W. P., 1997. NEXUS: an extensible file format for systematic information. \emph{Systematic Biology}, \bold{46}, 590-621.
}
\seealso{
\link{write_tnt_matrix}

\link{build_cladistic_matrix}, \link{compactify_cladistic_matrix}, \link{prune_cladistic_matrix}, \link{read_nexus_matrix}, \link{safe_taxonomic_reduction}, \link{write_tnt_matrix}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
