% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verticalruleplot.R
\name{verticalruleplot}
\alias{verticalruleplot}
\title{Vertical rule plot}
\usage{
verticalruleplot(E, d, Rules, col = NULL, legend = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, or RTalmud.}

\item{col}{The colours. If \code{col=NULL} then the sequence of default colours is:
c("red", "blue", "green", "yellow", "pink", "orange", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{legend}{A logical value. The colour legend is shown if \code{legend=TRUE}.}
}
\value{
This function represents the claims vector and the awards vector assigned by several rules as vertical segments.
}
\description{
For each claimant, it plots a vertical line with his claim and a point on the awards vector of the chosen rules.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

A vector \eqn{x=(x_1,\dots,x_n)} is an awards vector for the claims problem \eqn{(E,d)} if \eqn{0\le x \le d}
and satisfies the balance requirement, that is, \eqn{\sum_{i=1}^{n}x_i=E}.

A rule is a function that assigns to each claims problem \eqn{(E,d)} an awards vector,
that is, a division between the claimants of the amount available.

The formal definitions of the main rules are given in the corresponding function help.
}
\examples{
E=10
d=c(2,4,7,8)
Rules=c(Talmud,RA,AA)
col=c("red","green","blue")
verticalruleplot(E,d,Rules,col)
}
\references{
Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{pathawards}, \link{pathawards3}, \link{schedrule}, \link{schedrules}.
}
