% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{getstackedGlobalBarplot_and_Grid}
\alias{getstackedGlobalBarplot_and_Grid}
\title{Stacked Global Barplot Side-by-side (two treatments)}
\usage{
getstackedGlobalBarplot_and_Grid(
  CompTreatTable,
  Treat1,
  Treat2,
  ggrep = TRUE,
  max_pairsLegend = 1,
  force = 0.1,
  mx.overlaps = Inf,
  szggrepel = 6,
  xlb = "Vertex-Class Pairs",
  ...
)
}
\arguments{
\item{CompTreatTable}{Output of Compare_VertexClasses_sharedEdgeFeatures}

\item{Treat1}{Name treatment 1 as in table CompTreatTable}

\item{Treat2}{Name treatment 2 as in table CompTreatTable}

\item{ggrep}{logical. If TRUE includes ggrepel labels for every bar}

\item{max_pairsLegend}{If number of Edge Features >= max_pairsLegend, display number of Edge Features as ggrepel label}

\item{force}{Repelling force for ggrepel labels}

\item{mx.overlaps}{Max number of overlaps ggrepel}

\item{szggrepel}{Size ggrepel labels}

\item{xlb}{Name for x-axis}

\item{...}{Other parameters for inner functions, mainly ggplot2 visual parameters}
}
\value{
A gtable containing stacked barplots. The barplots show the vertex-class pairs profile of all shared edge features between two treatments (one bar plot per treatment). Every bar consists of multiple edge features that are depicted with different colors
}
\description{
This function will create a stacked barplot from the output of Compare_VertexClasses_sharedEdgeFeatures using all shared Edge Features (e.g., genes) between two treatments. Results of both Treatments are side by side for better comparison.
}
\examples{
data(VertexClassesSharedGenes_HFDvsChow)
VCSGs<-VertexClassesSharedGenes_HFDvsChow
HFD_vs_Chow_stackedBarplot<-getstackedGlobalBarplot_and_Grid(VCSGs,
                                                             Treat1 = "HFD",
                                                             Treat2 = "Chow",
                                                             xlb = "Metabolite-class-pairs",
                                                             max_pairsLegend=9)
plot(HFD_vs_Chow_stackedBarplot)
}
