% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeWindowCohorts.R
\name{timeWindowCohorts}
\alias{timeWindowCohorts}
\title{Split cohorts based on time-windows}
\usage{
timeWindowCohorts(
  cohort,
  window,
  cohortId = NULL,
  keepOriginalCohorts = TRUE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{window}{A list specifying the time windows (in days) used to split the
cohort. Each element must be a numeric vector of length 2:
\code{c(start_day, end_day)}, where the values are days since \code{cohort_start_date}.
Use \code{Inf} as the end value to indicate a window that extends until the
subject's \code{cohort_end_date}. If the list is named, window names will be used
to identify the output cohorts}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{keepOriginalCohorts}{If TRUE the original cohorts will be return
together with the new ones. If FALSE only the new cohort will be returned.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
A cohort table
}
\description{
Split cohorts based on time-windows
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
# if "cohort1" contained pregnancy episodes, we can generate trimester-specific
# cohorts with this function
cdm$pregnancy_trimesters <- timeWindowCohorts(
  cohort = cdm$cohort1,
  window = list(
    "trimester_1" = c(0, 90),
    "trimester_2" = c(91,180),
    "trimester_3" = c(181, Inf)
  ),
  cohortId = NULL,
  keepOriginalCohorts = FALSE,
  name = "pregnancy_trimesters"
)
}
}
