% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_with_robScore_functions.R
\name{consensus_matrix_data_prtrb}
\alias{consensus_matrix_data_prtrb}
\title{Calculate consensus matrix for data perturbation consensus clustering}
\usage{
consensus_matrix_data_prtrb(
  X,
  max.cluster = 5,
  resample.ratio = 0.7,
  max.itter = 100,
  clustering.method = "hclust",
  adj.conv = TRUE,
  verbos = TRUE
)
}
\arguments{
\item{X}{adjacency matrix a Nsample x Nsample}

\item{max.cluster}{maximum number of clusters}

\item{resample.ratio}{the data ratio to use at each itteration.}

\item{max.itter}{maximum number of itterations at each \code{max.cluster}}

\item{clustering.method}{base clustering method: \code{c("hclust", "spectral", "pam")}}

\item{adj.conv}{binary value to apply soft thresholding (default=\code{TRUE})}

\item{verbos}{binary value for verbosity (default=\code{TRUE})}
}
\value{
list of consensus matrices for each k
}
\description{
Calculate consensus matrix for data perturbation consensus clustering
}
\details{
performs data perturbation consensus clustering and obtain consensus matrix
Monti et al. (2003) consensus clustering algorithm
}
\examples{
X = gaussian_clusters()$X
Adj = adj_mat(X, method = "euclidian")
CM = consensus_matrix_data_prtrb(Adj, max.cluster=3, max.itter=10, verbos = FALSE)

}
