% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictContinuous.R
\name{predictContinuous}
\alias{predictContinuous}
\title{Conditional expectation for a copula-based estimation of mixed regression models for continuous response}
\usage{
predictContinuous(object, newdata = NULL, nq = 25)
}
\arguments{
\item{object}{Object of class ``EstContinuous`` generated by EstContinuous.}

\item{newdata}{List of variables for be predicted (``clu`` for clusters, ``xc`` for the copula covariates, and ``xm`` for the margins covariates). The covariates can be NULL.}

\item{nq}{number of nodes and weighted for Gaussian quadrature of the product of conditional copulas; default is 25.}
}
\value{
\item{mest}{Conditional expectations}
}
\description{
Compute the conditional expectation of a copula-based  2-level hierarchical model for continuous response.
}
\examples{
data(out.normal)
newdata=list(clu=c(1:50),xm=rep(0.4,50))
pred= predictContinuous(out.normal,newdata)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii and Bruno N. Remillard, January 20, 2023
}
