% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLowLcpmCutoff.R
\name{plot.empLCPM}
\alias{plot.empLCPM}
\title{Plot the empirically derived LCPM cutoff}
\usage{
\method{plot}{empLCPM}(x, main = "", col.trend = "purple", col.outlier = c("black", "red"), ...)
}
\arguments{
\item{x}{A 'empLCPM' object from \code{\link{getLowLcpmCutoff}}.}

\item{main}{An (optional) title for the plot.}

\item{col.trend}{Color used for the 3rd order polynomial fit.}

\item{col.outlier}{A vector specifying the default color for the points
in the scatterplot, and the color for the outlier points. The default is
to color all non-outlier points black and the outliers red.}

\item{...}{Additional arguments are ignored.}
}
\value{
The function \code{plot.empLCPM} creates a plot that summarizes 3rd
order polynomial fit for the Spearman correlation between the expected and
observed ERCC fold changes across log2 CPM abundance bins.  Vertical lines
are used to indicate the optimal cutoff value, along with the lower and upper
95\% bootstrap confidence interval highlighted by dashed vertical lines.
}
\description{
Plot method for class "empLCPM" that plots the 3rd order polynomial fit for
the Spearman correlation between the expected and observed ERCC fold changes
across log2 CPM abundance bins and highlights the empirically derived LCPM
cutoff.
}
