% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossExpression.R
\name{bullseye_scores}
\alias{bullseye_scores}
\title{Calculates bullseye statistics for ALL gene pairs.
Counts the number of cells with gene B in those with gene A
And in their neighbors
Neighbor scores are cumulative and normalized by window size.}
\usage{
bullseye_scores(
  data,
  locations,
  window_sizes = 1:5,
  ratio_to_co = FALSE,
  log_2 = FALSE,
  output_matrix = FALSE
)
}
\arguments{
\item{data}{A cells by genes expression matrix.}

\item{locations}{A cells by coordinates (x-y or higher dimensions) matrix.}

\item{window_sizes}{Vector of window sizes.}

\item{ratio_to_co}{If TRUE, results are normalized by co-expressing cells.}

\item{log_2}{If TRUE, results are transformed by log2.}

\item{output_matrix}{If TRUE, results are provided in matrix form.}
}
\value{
Returns a dataframe with each row representing a gene pair and each column representing
the bullseye score for that pair in each window size.
output_matrix = TRUE presents a matrix for each window size.
}
\description{
Calculates bullseye statistics for ALL gene pairs.
Counts the number of cells with gene B in those with gene A
And in their neighbors
Neighbor scores are cumulative and normalized by window size.
}
\examples{
data("locations")
data("expression")
locations  = as.matrix(locations)
expression = as.matrix(expression)
expression = expression[,1:5]
results    = bullseye_scores(data = expression, locations = locations)

}
