% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printmodid.R
\name{print.modid}
\alias{print.modid}
\title{Print Method for S3 Objects of Class \code{modid}}
\usage{
\method{print}{modid}(x, ...)
}
\arguments{
\item{x}{A S3 object of class \code{modid}.}

\item{...}{Additional arguments.}
}
\value{
A printed message reporting the number of factors and the suggested model identification items.
}
\description{
The print method for the \code{\link[=modid]{modid()}} function.
}
\examples{
\dontrun{
# Load data
data("anes0809offwaves")
x <- anes0809offwaves
x <- x[,3:22] # Remove columns for age and gender

# Identify the DMIRT model
id <- modid(x)

# Print model identification summary
print(id)
}
}
