% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rec.mean.var.R
\name{rec.mean.var}
\alias{rec.mean.var}
\title{rec.mean.var}
\usage{
rec.mean.var(y)
}
\arguments{
\item{y}{a (non-empty) numeric vector of data with ceiling/floor effects}
}
\value{
\item{ceiling.percentage}{the percentage of ceiling values in the data}
        \item{floor.percentage}{the percentage of floor values in the data}
        \item{est.mean}{estimated mean of the true scores}
        \item{est.var}{estimated variance of the true scores}
}
\description{
recover mean and variance of the data with ceiling/floor effects
}
\examples{
# simulate normally distributed true scores
x=rnorm(1000,2,4)
mean(x); var(x)
# induce 20\% floor effects
# and estimate the true mean variance from the floor data
x.f=induce.cfe(.2,0,x)
rec.mean.var(x.f)
# induce 20\% ceiling effects
# and estimate the true mean and variance from the ceiling data
x.c=induce.cfe(0,.2,x)
rec.mean.var(x.c)
# induce 20\% and 10\% of floor and ceiling effects, respectively
# and estimate the true mean and variance from the data with floor and ceiling effects
x.cf=induce.cfe(.2,.1,x)
rec.mean.var(x.cf)
}
