% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{classify_nodes}
\alias{classify_nodes}
\title{Classify DAG nodes}
\usage{
classify_nodes(dag, exposure, outcome)
}
\arguments{
\item{dag}{A \code{dagitty} DAG object.}

\item{exposure}{Optional-- inferred from DAG if not set; character; exposure node name (Exp.).}

\item{outcome}{Optional-- inferred from DAG if not set; character; outcome node name (Out.).}
}
\value{
A data.frame with one row per node and columns:
\itemize{
\item \code{variable} (node name)
\item logical flags: \code{is_exposure}, \code{is_outcome}, \code{is_confounder},
\code{is_mediator}, \code{is_collider}, \code{is_neutral_on_treatment},
\code{is_neutral_on_outcome}, \code{is_descendant_of_mediator},
\code{is_descendant_of_collider}, \code{is_descendant_of_confounder_on_bdp},
\code{is_descendant_of_confounder_off_bdp}
\item \code{role} (a single primary label)
}
}
\description{
Labels each node by causal role in a console tabular grid. This function is
mostly used as an internal helper, but can be used on its own. Users are
encouraged to alternatively use \code{DAGassist::DAGassist(show=roles)} for role
table specific output.
}
\note{
Roles legend:
\code{Exp.} = exposure
\code{Out.} = outcome
\code{CON} = confounder
\code{MED} = mediator
\code{COL} = collider
\code{dOut} = descendant of Out.
\code{dMed} = descendant of any mediator,
\code{dCol} = descendant of any collider
\code{dConfOn} = descendant of a confounder on a back-door path
\code{dConfOff} = descendant of a confounder off a back-door path
\code{NCT} = neutral control on treatment
\code{NCO} = neutral control on outcome
}
\examples{
  d1 <- dagitty::dagitty("dag {X[exposure];Y[outcome] Z -> X; Z -> Y; X -> Y }") 
  classify_nodes(d1)
  
}
