\name{KPgLastOccurrences.rdata}
\alias{KPgLastOccurrences}
\docType{data}
\title{Last occurrences for the K/Pg boundary and a potential influence of Deccan volcanism}
\description{
Contains last occurrences generated by a spike in extinction rate at the K/Pg boundary and an influence of Deccan volcanism before that. Relative influence of volcanism ranges from 0\% (none), 10 \% (weak), 20\% (intermediate), 30 \% (strong) to 40\% (very strong).
Location of Deccan volcanism is based on the extinction interval from Tobin (2017), fig. 5, transformed into time assuming a constant deposition rate.
The last occurrences were generated based on the convolution procedure described in Hohmann (2018) and a rate of fossil occurrences of 40 fossils per Myr.
}
\usage{data(KPgLastOccurrences)}
\format{A list with five entries, each named after the intensity of the early extinction pulse described in Hohmann (in preparation). Each of these entries contains three vectors: 'val' contains the last occurrences per Myr at the ages in 'age', and 'parameters' contains the parameters used to create the pattern of last occurrences.
}

\examples{
data(KPgLastOccurrences)
KPgLastOccurrences$Intermediate.Deccan$parameters
plot(KPgLastOccurrences$Intermediate.Deccan$age,
  KPgLastOccurrences$Intermediate.Deccan$val,type='l',
  xlim=rev(range(KPgLastOccurrences$Intermediate.Deccan$age)),xlab='Age [Ma]',
  ylab='Last Occurrences [per Myr]')
}
\source{
Hohmann, Niklas. 2018. Quantifying the Effects of Changing Deposition Rates and Hiatii on the Stratigraphic Distribution of Fossils. <doi:10.13140/RG.2.2.23372.51841>.
}

\references{
Hohmann, Niklas. (2018). Reversing Time Averaging and Reconstructing Extinction Rates with Approaches from Image Processing. DOI 10.1101/408864. 

Tobin, Thomas S. "Recognition of a likely two phased extinction at the K-Pg boundary in Antarctica." Scientific reports 7.1 (2017): 1-11.
}

\keyword{dataset}
\keyword{Seymour}
\keyword{K/Pg}
\keyword{Stratigraphy}