% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_missing_species.R
\name{count_missing_species}
\alias{count_missing_species}
\title{Reads in the checklist of all species on an island, including those that are
not in the phylogeny (represented by NA) and counts the number of species
missing from the phylogeny each genus}
\usage{
count_missing_species(
  checklist,
  phylo_name_col,
  genus_name_col,
  in_phylo_col,
  endemicity_status_col,
  rm_species_col = NULL
)
}
\arguments{
\item{checklist}{data frame with information on species on the island}

\item{phylo_name_col}{A character string specifying the column name where the
names in the phylogeny are in the checklist}

\item{genus_name_col}{A character string specifying the column name where the
genus names are in the checklist}

\item{in_phylo_col}{A character string specifying the column name where the
status of whether a species is in the phylogeny is in the checklist}

\item{endemicity_status_col}{A character string specifying the column name
where the endemicity status of the species are in the checklist}

\item{rm_species_col}{A character string specifying the column name where
the information on whether to remove species from the checklist before
counting the number of missing species is in the checklist. This can be NULL
if no species are to be removed from the checklist. This is useful when
species are in the checklist because they are on the island but need to be
removed as they are not in the group of interest, e.g. a migratory bird
amongst terrestrial birds}
}
\value{
Data frame
}
\description{
Reads in the checklist of all species on an island, including those that are
not in the phylogeny (represented by NA) and counts the number of species
missing from the phylogeny each genus
}
\examples{
mock_checklist <- data.frame(
  genus = c("bird", "bird", "bird", "bird", "bird", "bird", "bird",
            "bird", "bird", "bird"),
  species = c("a", "b", "c", "d", "e", "f", "g", "h", "i", "j"),
  species_names = c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e",
                    "bird_f","bird_g", "bird_h", "bird_i", "bird_j"),
  sampled = c(TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE),
  endemicity_status = c("endemic", "endemic", "endemic", "nonendemic",
                        "endemic", "nonendemic", "endemic", "endemic",
                        "endemic", "endemic"),
  remove_species = (rep(FALSE, 10))
)

missing_species <- count_missing_species(
  checklist = mock_checklist,
  phylo_name_col = "species_names",
  genus_name_col = "genus",
  in_phylo_col = "sampled",
  endemicity_status_col = "endemicity_status",
  rm_species_col = NULL
)
}
