% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_example.R
\name{build_example}
\alias{build_example}
\title{Simulation of gene expressions using independant negative binomials}
\usage{
build_example(
  m = 500,
  m1,
  n1 = 6,
  n2 = n1,
  fold = 100,
  mu0 = 100,
  use.scales = FALSE,
  nb.size = Inf
)
}
\arguments{
\item{m, }{number of genes}

\item{m1, }{number of differentially expressed genes. In the expression matrix, m1 first columns contain differentially expressed genes.}

\item{n1, }{number of samples under the first condition. The first n1 rows in the expression matrix.}

\item{n2, }{number of samples under the second condition (default n2=n1)}

\item{fold, }{maximal fold change added to the first m1 genes. The fold decreases proportionally to \code{1/sqrt(1:m1)}.}

\item{mu0, }{mean relative expression}

\item{use.scales, }{if TRUE random scales are used, otherwise all scales are set to 1.}

\item{nb.size, }{number of successful trials in the negative binomial distribution. If nb.size is set to Inf (default), the Poisson model is used.}
}
\value{
A list with components
\describe{
\item{\code{X}}{a two-dimensional array containing the expression table of n individuals in rows and m gene expressions in columns. }
\item{\code{m1}}{number of differentially expressed genes (as in arguments).}
\item{\code{n1}}{number of samples under the first condition (as in arguments).}
\item{\code{n2}}{number of samples under the second condition (as in arguments).}
\item{\code{fold}}{maximal fold change between the differentally expressed genes and invariant genes (as in arguments). }
\item{\code{scales}}{vector of simulated scales.}
\item{\code{mu0}}{mean relative expression (as in arguments).}
}
}
\description{
Simulation of gene expressions using independant negative binomials
}
\details{
The function generates a list, of which the first element \code{X} is a matrix of \code{n1+n2} and m dimension with simulated expressions under Poisson or Negative Binomial distribution. Lines \code{1:n1} correspond to the first condition (or sub-group) and lines \code{(n1+1):(n1+n2)} to the second one. Columns \code{1:m1} contain counts imitating differential expressions.

In the ideal situation there is no microscopical variability between samples and all scales (so-called scaling factors) would be the same.  To simulate examples corresponding to this perfect situation, use argument \code{use.scales=FALSE} which will set all scales to 1.  When \code{use.scales=TRUE}, scales are simulated under uniform distribution \emph{Unif(0.25,4)}.

The fold is maximal for the first expression and decreases proportionally to \code{1/sqrt(1:m1)}. The smallest fold  \code{fold/sqrt(m1)} is set to the \emph{m1}-th expression.
}
\examples{

L = build_example(m=500,m1=25,n1=6,fold=20,mu0=100,use.scales=FALSE,nb.size=Inf)
}
