% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knutils.R
\name{knbinary}
\alias{knbinary}
\title{Constructs data frame with clusters in binary format.}
\usage{
knbinary(datamap, knresults)
}
\arguments{
\item{datamap}{data of the \link[sp]{SpatialPolygonsDataFrame} with the polygons
of the map.}

\item{knresults}{data frame with information of the detected clusters.
Each row represents the information of one of the clusters.
It contains the coordinates of the center, the size, the start
and end dates, the log-likelihood ratio, a boolean indicating if it is a
cluster (TRUE in all cases), and the p-value of the cluster.}
}
\value{
data frame where the columns represent the clusters in binary format.
The position i of the column is equal to 1 if the polygon i is in the cluster
or 0 if it is not in the cluster.
}
\description{
This function constructs a data frame with number of columns equal to the
number of clusters. Each column is a binary representation of one of the
clusters. The position i of the column is equal to 1 if the polygon i is
in the cluster or 0 if it is not in the cluster.
}
\examples{
library("DClusterm")
library("RColorBrewer")

data("NY8")
data("NY8_clusters")

stcl <- knbinary(NY8, ny.cl1)
#Get first cluster
NY8$CLUSTER <- stcl[, 1]

#Plot cluster
spplot(NY8, "CLUSTER", at = c(0, 0.5, 1.5), col = "#4D4D4D",
  col.regions = c("white", "gray"))

}
