% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlgoParamsDEMCMC.R
\name{AlgoParamsDEMCMC}
\alias{AlgoParamsDEMCMC}
\title{AlgoParamsDEMCMC}
\usage{
AlgoParamsDEMCMC(
  n_params,
  n_chains = NULL,
  param_names = NULL,
  n_iter = 1000,
  init_sd = 0.01,
  init_center = 0,
  n_cores_use = 1,
  step_size = NULL,
  jitter_size = 1e-06,
  parallel_type = "none",
  burnin = 0,
  thin = 1
)
}
\arguments{
\item{n_params}{number of free parameters estimated}

\item{n_chains}{number of MCMC chains, 3*n_params is the default value}

\item{param_names}{optional vector of parameter names}

\item{n_iter}{number of iterations to run the sampling algorithm, 1000 is default}

\item{init_sd}{positive scalar or n_params-dimensional numeric vector, determines the standard deviation of the Gaussian initialization distribution}

\item{init_center}{scalar or n_params-dimensional numeric vector, determines the mean of the Gaussian initialization distribution}

\item{n_cores_use}{number of cores used when using parallelization.}

\item{step_size}{positive scalar, jump size in DE crossover step, default is 2.38/sqrt(2*n_params) which is optimal for multivariate Gaussian target distribution (ter Braak, 2006)}

\item{jitter_size}{positive scalar, noise is added during crossover step from Uniform(-jitter_size,jitter_size) distribution. 1e-6 is the default value.}

\item{parallel_type}{string specifying parallelization type. 'none','FORK', or 'PSOCK' are valid values. 'none' is default value.}

\item{burnin}{number of initial iterations to discard. Default value is 0.}

\item{thin}{positive integer, only every 'thin'-th iteration will be stored. Default value is 1. Increasing thin will reduce the memory required, while running chains for longer.}
}
\value{
list of control parameters for the DEMCMC function
}
\description{
AlgoParamsDEMCMC
}
