% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_func.R
\name{dehogt_func}
\alias{dehogt_func}
\title{Differentially Expressed Heterogeneous Overdispersion Genes Testing for Count Data
This script implements the main function of the proposed method in the above paper}
\usage{
dehogt_func(
  data,
  treatment,
  norm_factors = NULL,
  covariates = NULL,
  dist = "qpois",
  padj = TRUE,
  pval_thre = 0.05,
  l2fc = FALSE,
  l2fc_thre = 1,
  num_cores = 1
)
}
\arguments{
\item{data}{A matrix of gene expression data where rows represent genes and columns represent samples.}

\item{treatment}{A vector specifying the treatment conditions for each sample.}

\item{norm_factors}{An optional vector of normalization factors for each sample. Default is NULL, which assumes equal normalization factors.}

\item{covariates}{An optional matrix of gene-wise covariates. Default is NULL.}

\item{dist}{The distribution family for the GLM. Can be "qpois" for quasi-Poisson or "negbin" for negative binomial. Default is "qpois".}

\item{padj}{Logical value indicating whether to adjust p-values using the Benjamini-Hochberg (BH) procedure. Default is TRUE.}

\item{pval_thre}{The threshold for identifying differentially expressed genes based on adjusted p-values. Default is 0.05.}

\item{l2fc}{Logical value indicating whether to consider log2 fold change for identifying differentially expressed genes. Default is FALSE.}

\item{l2fc_thre}{The threshold for log2 fold change in identifying differentially expressed genes. Default is 1.}

\item{num_cores}{The number of CPU cores to use for parallel computing. Default is 1.}
}
\value{
A list containing:
\item{DE_idx}{A logical vector indicating differentially expressed genes.}
\item{pvals}{A numeric vector of p-values for each gene.}
\item{log2fc}{A numeric vector of log2 fold changes for each gene.}
}
\description{
Differentially Expressed Heterogeneous Overdispersion Genes Testing for Count Data
This script implements the main function of the proposed method in the above paper
}
\examples{
# simulate gene expression data
data <- matrix(rpois(1000, 10), nrow = 100, ncol = 10)
# simulate random treatment assignments
treatment <- sample(0:1, 10, replace = TRUE)
# Run main function with parallel computing using 2 cores
result <- dehogt_func(data, treatment, num_cores = 2)
}
