% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{evaluation_parameters}
\alias{evaluation_parameters}
\title{evaluation_parameters}
\usage{
evaluation_parameters(
  method = EnumEvalMethod,
  norm = NULL,
  and = NULL,
  or = NULL
)
}
\arguments{
\item{method}{One of: \code{"set"} (default), \code{"prob"}, \code{"fuzzy"} or \code{"fuzzynorm"}.}

\item{norm}{Some normalization function of the form \verb{function(num_vector)}, or \code{NULL}.}

\item{and}{Some conjunctive aggregation function of the form \verb{function(num_vector)}, or \code{NULL}.}

\item{or}{Some disjunctive aggregation function of the form \verb{function(num_vector)}, or \code{NULL}.}
}
\value{
\code{list(method, norm, and, or)}.
For \code{NULL} \code{norm}, \code{and}, and \code{or} arguments, defaults are
taken depending on the \code{method}.
}
\description{
Make a list containing parameters of DEXi evaluation. The parameters determine which method
and normalization/aggregation functions should be used by \code{\link[=evaluate]{evaluate()}}.
}
\examples{
evaluation_parameters("prob", norm = norm_none)

}
\seealso{
\link{evaluate}, \code{\link[=normalize_function]{normalize_function()}},
\code{\link[=norm_none]{norm_none()}}, \code{\link[=norm_max]{norm_max()}}, \code{\link[=norm_sum]{norm_sum()}}, \code{\link[=and_function]{and_function()}}, \code{\link[=or_function]{or_function()}}.
}
