% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{set_alternative}
\alias{set_alternative}
\title{set_alternative}
\usage{
set_alternative(model, alternative, ...)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternative}{\code{character(1)} or \code{data.frame}. The first form sets the name of the
newly created decision alternative. The second form copies values from \code{alternative[1, ]}
to initialize the corresponding columns of the resulting data frame.}

\item{...}{A list of parameters specifying the values of the newly created decision alternative.
Each parameter is expected to be in the form \code{attribute_id=attribute_value}, or is a list of
elements of the same form.

There are several possible ways to specify \code{attribute_value}.
Taking the scale \code{CAR = \{"unacc"; "acc"; "good"; "exc"\}} as an example, the options are:
\describe{
\item{\code{CAR="unacc"}}{A single qualitative value.}
\item{\code{CAR=2}}{An ordinal number, indicating \code{"acc"} in this case.}
\item{\code{CAR=c("good", "exc")}}{A set of qualitative values.}
\item{\code{CAR=c(3, 4)}}{A set of ordinal numbers, equivalent to the above.}
\item{\code{CAR=list("good", 4)}}{A set specified by a mixture of qualitative values and ordinal numbers.}
\item{\code{CAR="*"}}{A full range of ordinal numbers, in this case equivalent to \code{1:4}.}
\item{\code{CAR=distribution(0, 0, 0.7, 0.3)}}{A value distribution.}
\item{\code{CAR=list("good"=0.7, "exc"=0.3)}}{A value distribution, equivalent to the above.}
\item{\code{CAR="undef"}}{An unknown value, interpreted as \code{NA}.}
}
For attributes associated with continuous scales,
only \code{numeric(1)} \code{attribute_value}s are allowed.}
}
\value{
A one-row data frame with columns corresponding to \code{model}'s attributes, collectively
representing a single decision alternative. The columns not copied from \code{alternative} (as a data frame)
nor set by any parameter contain \code{NA}s.
}
\description{
Set values of a single decision alternative and represent it with a data frame.
Usually, only input values are set in this way. The data frame can then be
\link{evaluate}d to set the values of output attributes.
}
\seealso{
\link{DEXiR-package} notes on values in DEXi models.
}
