% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{write_alternatives}
\alias{write_alternatives}
\title{write_alternatives}
\usage{
write_alternatives(
  model,
  alternatives = NULL,
  file = "",
  quote = FALSE,
  format = c("tab", "csv", "csv2"),
  ...
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternatives}{A \code{data.frame} of alternatives (normally an output of \code{\link[=evaluate]{evaluate()}}) or
indices to \code{model$alternatives}. The default value \code{NULL} selects \code{model$alternatives}.}

\item{file}{Write the data frame contents to a file.
When \code{file = ""}, the contents is written to the console (default).
\code{file = "clipboard"} might also work to copy the contents to the clipboard.}

\item{quote}{\code{logical(1)}. Whether or not to quote output character strings.}

\item{format}{One of \code{"tab"}, \code{"csv"} or \code{"csv2"} to
invoke \code{\link[=write.table]{write.table()}}, \code{\link[=write.csv]{write.csv()}} or \code{\link[=write.csv2]{write.csv2()}}, respectively.}

\item{...}{Optional parameters to \code{\link[=write.table]{write.table()}} functions.}
}
\value{
Writes a "tab"- or "csv"-formatted \code{alternatives}' data to a file,
console or clipboard. This data is meant to be subsequently imported to
'DEXi' software.
}
\description{
Write out \code{alternatives}' data. First convert DEXi alternatives to a data frame using
\code{\link[=export_alternatives]{export_alternatives()}} and then write it to a file.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Write both Car alternatives to console
write_alternatives(Car, file = "")
}
\seealso{
\code{\link[=export_alternatives]{export_alternatives()}}, \code{\link[=write.table]{write.table()}}
}
