% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\encoding{UTF-8}
\name{map_plot}
\alias{map_plot}
\title{Plot Regionalized Data on Maps of Germany}
\usage{
map_plot(
  data,
  var,
  map_section = "",
  level = "",
  add_labels,
  year,
  geo_year,
  palette = ""
)
}
\arguments{
\item{data}{Data frame. The dataset containing the variable to be plotted.}

\item{var}{Character. The name of the variable (column) in \code{data} to be visualized.}

\item{map_section}{Character vector of AGS codes or federal state shortcuts. Used to define the outer boundaries of the map. Shortcuts are available for Germany ("DE") and for each federal state (e.g., "BE" for Berlin). For other areas, providing an AGS code is necessary, which can be looked up using the \code{list_codes} function.}

\item{level}{Character "land", "kreis", or "gemeinde". Used to define the inner boundaries, i.e. the areas which will be plotted within \code{map_section}. For example, to plot districts in the state of Brandenburg specify \code{map_section = "BB"} and \code{level = "kreis"}.}

\item{add_labels}{Logical. Whether to show numeric labels on the map. If TRUE, will not only fill each area specified in \code{level} with a color but also print the number provided in \code{var} on the map.}

\item{year}{Integer. Year of the data to be plotted. Will detect the respective column in \code{data} if it is named "Year" or "Jahr" and filter the year specified. Will by default also determine the year from which the geospatial data (shapefiles) will be used (see \code{geo_year}). Useful if \code{data} contains information from multiple years.}

\item{geo_year}{Integer or "". Year of the geodata to use; defaults to "" for which the year provided in \code{year} is used. Specify manually to plot data from a given year using geospatial data from a different year. Can be useful in case of matching issues.}

\item{palette}{Character. Name of the color palette ("Red", "Blue", etc.).}
}
\value{
A ggplot2 object visualizing the provided regional data. Can be further customized.
}
\description{
Visualizes regional data by creating maps of Germany. Currently supports states (Länder), districts (Kreise, kreisfreie Städte), and municipalities (Gemeinde). Can be used to plot any lower level within a higher one, e.g. states within Germany or municipalities within a district.
}
\examples{
\donttest{
data <- nstudents2022 # provide the data you want to plot here

# Example: Plotting the number of students in Germany by state
map_plot(
  data = data,               # the dataset containing the variable to plot
  var = "nStudents",         # the variable to plot
  map_section = "DE",        # plot entire Germany
  level = "land",            # plot by state
  add_labels = FALSE,        # do not show labels
  year = 2022,               # year of the data
  geo_year = "",             # use the same year for geodata
  palette = "red"            # use red color palette
)
}

}
\keyword{germany}
\keyword{mapping}
\keyword{shapefiles}
\keyword{visualization}
