% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSVA.R
\name{runSVA}
\alias{runSVA}
\title{Test for surrogate variables}
\usage{
runSVA(dgeObj, designMatrixName, n.sv, method = "leek")
}
\arguments{
\item{dgeObj}{A DGEobj with normalized counts and a designMatrix.}

\item{designMatrixName}{The itemName of the design matrix in DGEobj.}

\item{n.sv}{Optional; Use to override the default n.sv returned by num.sv
for the number of SV to analyze.}

\item{method}{Method passed to num.sv. Supports "leek" or "be". (Default =
"leek")}
}
\value{
dgeObj containing an updated design table, the svobj and a new design
  matrix.
}
\description{
Takes a DGEobj from runVoom and tests for surrogate variables. Adds a new
design matrix to the DGEobj with the surrogate variable columns appended using cbind.
runVoom should then be run again with the new design matrix to complete the
analysis.
}
\examples{
\dontrun{
   # NOTE: Requires the sva package

    dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    ###  Create a model based on surgery status, intentionally omitting the compound treatments
    dgeObj$design$SurgeryStatus <- "BDL"
    dgeObj$design$SurgeryStatus[dgeObj$design$ReplicateGroup == "Sham"] <- "Sham"
    formula <- '~ 0 + SurgeryStatus'
    designMatrix <- model.matrix (as.formula(formula), dgeObj$design)

    # Make sure the column names in the design matrix are legal
    colnames(designMatrix) <- make.names(colnames(designMatrix))

    #capture the formula as an attribute of the design matrix
    attr(designMatrix, "formula") <- formula

    #add the designMatrix to the DGEobj
    dgeObj <- DGEobj::addItem(dgeObj,
                              item      = designMatrix,
                              itemName  = "SurgeryStatusDesign",
                              itemType  = "designMatrix",
                              parent    = "design",
                              overwrite = TRUE)

    dgeObj <- runSVA(dgeObj, designMatrixName = "SurgeryStatusDesign")
}

}
