% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_CMP.R
\name{summary.glm_CMP}
\alias{summary.glm_CMP}
\alias{print.summary.glm_CMP}
\title{Summarizing COM-Poisson Fits}
\usage{
\method{summary}{glm_CMP}(object, ...)

\method{print}{summary.glm_CMP}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{"glm_CMP"}, usually, a result of a call
to \code{glm.CMP}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.glm_CMP"}, usually, a result of a
call to \code{summary.glm_CMP}.}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If \code{TRUE}, \sQuote{significance stars}
    are printed for each coefficient.}
}
\description{
These functions are all methods for class \code{"glm_CMP"} or
\code{summary.glm_CMP} objects.
}
\examples{
## Fit a COM-Poisson model
Bids$size.sq <- Bids$size^2
fit <- glm.CMP(formula.mu = numbids ~ leglrest + rearest + finrest +
               whtknght + bidprem + insthold + size + size.sq + regulatn,
               formula.nu = numbids ~ 1, data = Bids)

## Obtain a summary of the fitted model

summary(fit)
}
