% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_names.R
\name{get_package_names}
\alias{get_package_names}
\title{Get used package names from R/qmd-files.}
\usage{
get_package_names(
  paths = c("."),
  file_endings = c("R", ".qmd"),
  pretty = TRUE,
  include_package_versions = TRUE
)
}
\arguments{
\item{paths}{A character vactor with the paths to all files to be searched.
Default: "." (so the current directory).}

\item{file_endings}{A character vector containing the file types to search
through. Default: "R" and "qmd". Case-sensitive!}

\item{pretty}{Logical. If `TRUE` (default), the result will be
a single string containing all packages combined in one single string.
If `FALSE`, the result will be a vector, containg all packages
so one can apply the pretty formatting on his/her own.}

\item{include_package_versions}{Logical. If `TRUE` (default), the result
will contain also the currently installed version of the package.
If the package is not installed, the version will be needed to be fixed
manually (output will be "tbd").}
}
\value{
A vector of all found package names.
}
\description{
E.g. for publication purposes it might be useful to
  quickly get all used package names out of a bunch of used scripts.
  This function takes the path to all the scripts and extracts the used
  package names if they are used in the manner "packagename::function()".
}
\examples{
\dontrun{
paths <- c("~", "/path/to/project/R")
get_package_names(
  paths = paths
)
}
}
