% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIPC.R
\name{DIPC}
\alias{DIPC}
\title{Distributed Incremental Principal Component Analysis (DIPC)}
\usage{
DIPC(data, m, eta, K)
}
\arguments{
\item{data}{Matrix of input data (n × p).}

\item{m}{Number of principal components.}

\item{eta}{Proportion of  initial batch to  total data  within each node.}

\item{K}{Number of nodes (distributed splits).}
}
\value{
List with per-node results and aggregated averages.
}
\description{
Apply IPC in a distributed manner across K nodes.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- DIPC(data, m, eta=0.8, K=5)
}
