% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{mixML}
\alias{mixML}
\title{Maximisation of the likelihood for one or more mixed traces of DNA}
\usage{
mixML(
  mixture,
  pars,
  constraints = NULL,
  phi.eq = FALSE,
  val = NULL,
  trace = FALSE,
  order.unknowns = TRUE,
  ...
)
}
\arguments{
\item{mixture}{A \code{\link{DNAmixture}} object.}

\item{pars}{A \code{\link{mixpar}} parameter used as a starting value for the optimisation.}

\item{constraints}{Equality constraint function as function of an array of parameters.}

\item{phi.eq}{Should the mixture proportions be the same for all
traces? Defaults to FALSE.}

\item{val}{Vector of values to be satisfied for the equality constraints.}

\item{trace}{Print the evaluations of the likelihood-function during optimisation?}

\item{order.unknowns}{Should unknown contributors be ordered
according to decreasing contributions? Defaults to TRUE.}

\item{...}{Further arguments to be passed on to \code{\link[Rsolnp]{solnp}}.}
}
\value{
A list containing
   \item{mle}{The (suggested) MLE.}
   \item{lik}{The log of the likelihood (log e).}
as well as the output from the optimisation.
}
\description{
\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\details{
The pre-specified constraints for the model parameter \code{pars} are for each mixture \code{r}
\itemize{
\item \code{0 <= pars[[r, "rho"]] < Inf}
\item \code{0 <= pars[[r, "eta"]] < Inf}
\item \code{0 <= pars[[r, "xi"]] <= 1}
\item \code{0 <= pars[[r, "phi"]][i] <= 1}
\item \code{sum(pars[[r, "phi"]]) == 1}.
\item If there are 2 or more unknown contributors, then the mixture
proportions for the unknown contributors are ordered decreasingly
with the first DNA mixture determining the order.
}
Further constraints can be specified by the user; for this see examples below.
}
\examples{

data(MC15, USCaucasian)
mix <- DNAmixture(list(MC15), C = list(50), k = 3, K = c("K1", "K2", "K3"), database = USCaucasian)
startpar <- mixpar(rho = list(24), eta = list(37), xi = list(0.08),
                   phi = list(c(K3 = 0.15, K1 = 0.8, K2 = 0.05)))
ml <- mixML(mix, startpar)
ml$mle

\donttest{
data(MC15, USCaucasian)
mix <- DNAmixture(list(MC15), C = list(50), k = 3, K = "K1", database = USCaucasian)
startpar <- mixpar(rho = list(24), eta = list(37), xi = list(0.08),
phi = list(c(U1 = 0.05, K1 = 0.8, U2 = 0.15)))
ml <- mixML(mix, startpar)
ml$mle
}

\donttest{
## The following advanced example has a model with two DNA samples
## and various parameter restrictions.
## Be aware that the computation is rather demanding and takes
## a long time to run with this lite-version of DNAmixtures.
## With DNAmixtures (based on HUGIN), it takes only about one minute.
data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = "K1", database = USCaucasian)
startpar <- mixpar(rho = list(24, 25), eta = list(37, 40), xi = list(0.08, 0.1),
                   phi = list(c(U1 = 0.05, K1 = 0.7, U2 = 0.25),
                                c(K1 = 0.7, U2 = 0.1, U1 = 0.2)))
eqxis <- function(x){ diff(unlist(x[,"xi"])) }
## Note that for these two traces, we do not expect phi to be equal.
## Here we set stutter equal for all traces
ml.diff <- mixML(mix, startpar, eqxis, val = 0, phi.eq = FALSE)
## Equal mixture proportions across traces
ml.eqphi <- mixML(mix, startpar, eqxis, val = 0, phi.eq = TRUE)
## Likelihood ratio test for equal mixture proportions
pchisq(-2*(ml.eqphi$lik - ml.diff$lik), df = 1, lower.tail = FALSE)
}
}
\seealso{
\code{\link{DNAmixture}}
}
\author{
Therese Graversen
}
