% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapping.R
\name{wGMVOverlapping}
\alias{wGMVOverlapping}
\title{Dynamic optimal shrinkage estimator of the weights of the global minimum
variance portfolio when overlapping samples are used.}
\usage{
wGMVOverlapping(data, reallocation_points, target_portfolio, relative_loss)
}
\arguments{
\item{data}{an n by p matrix of asset returns. Columns represent different
assets rows are observations, where n>p, containing, for instance, log-returns.}

\item{reallocation_points}{a vector of reallocation points. The reallocation
points determine when the holding portfolio should be reconstructed and it is
weights should be recomputed.}

\item{target_portfolio}{a vector which determines the weights of the target
portfolio used when the shrinkage estimator of the global minimum variance
portfolio is constructed for the first time.}

\item{relative_loss}{possibly a numeric or NULL. The initial value of the
relative loss in the variance of the target portfolio. If it is NULL, then it
will be initialized with the first subsample and the function
\code{\link{r0Strategy}}.}
}
\value{
a matrix of the constructed weights at each reallocation point of the
dynamic shrinkage estimator of the global minimum variance portfolio when
overlapping samples are used.
}
\description{
The function implements the dynamic shrinkage estimator of the weights of the
global minimum-variance portfolio when the overlapping samples are used as
given in Eq. (2.23) of  \insertCite{BODNAR21dynshrink;textual}{DOSPortfolio}.
}
\examples{
n <- 200*2
p <- 80
reallocation_points <- c(199)
data <- matrix(rt(n*p, df=5), ncol=p, nrow=n)
target_portfolio <- as.vector(rep(1,p))/p
wGMVOverlapping(data, reallocation_points, target_portfolio, 1)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{wGMVNonOverlapping}}
}
