% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_predictive.R
\name{post_predictive}
\alias{post_predictive}
\title{Posterior Predictive Check}
\usage{
post_predictive(
  mcmc_samples,
  dis_matrix,
  nsim = 1000,
  scale = TRUE,
  plot = TRUE
)
}
\arguments{
\item{mcmc_samples}{An object of class \code{mcmc} or \code{mcmc.list} containing posterior samples from a DPCD model fit using \code{\link[=run_dpcd]{run_dpcd()}}. Both the latent positions \code{x} and the error variance \code{sigma_sq} must be included in \code{mcmc_samples}.}

\item{dis_matrix}{A distance structure such as that returned by \link[stats:dist]{stats::dist} or a full symmetric matrix containing the dissimilarities.}

\item{nsim}{Number of datasets to simulate from the posterior predictive distribution.}

\item{scale}{Logical argument indicating whether to scale the dissimilarities so that the maximum value is 1.}

\item{plot}{Logical argument indicating whether to plot the simulated dissimilarities against the observed dissimilarities. See details for more information.}
}
\value{
A matrix of simulated dissimilarities from the posterior predictive distribution with \code{nsim} rows and \code{n * (n-1) / 2} columns, where \code{n} is the number of objects (i.e. the number of rows/columns of \code{dis_matrix}).
}
\description{
This function simulates dissimilarities from the posterior predictive distribution of a specified DPCD model and optionally plots the density of the simulated dissimilarities against the observed dissimilarities.
}
\details{
A posterior predictive check is used to assess if datasets drawn from the posterior predictive distribution are consistent with the observed data. Posterior predictive checks differ from prior predictive checks in that they incorporate information from the observed data. If the model fits the data well, the observed dissimilarities should look similar to dissimilarities simulated from the posterior predictive distribution.

If \code{plot = TRUE}, a plot is created to compare the density of the observed dissimilarities to the densities of the dissimilarities simulated from the posterior predictive distribution using \code{bayesplot::ppc_dens_overlay()}.

See \code{\link[=run_dpcd]{run_dpcd()}} for details on the DPCD models and hyperparameters.
}
\examples{
ppc <- post_predictive(mcmc_example, dis_mat_example, nsim = 100, plot = TRUE)
}
\references{
Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., & Gelman, A. (2019).
Visualization in Bayesian workflow. Journal of the Royal Statistical Society A,
182(2), 389–402. https://doi.org/10.1111/rssa.12378
}
\seealso{
\code{\link[=run_dpcd]{run_dpcd()}}
}
