% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plothot.R
\name{plothot}
\alias{plothot}
\title{Plots an object obtained with \code{DiffHotspots_n_k}}
\usage{
plothot(X, hotspots, order_extension = NULL, which.plot = NULL, eps_image = F)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a road network (\code{linnet} object)}

\item{hotspots}{- A set of differential risk hotspots obtained with the function \code{DiffHotspots_n_k}}

\item{order_extension}{- A natural number indicating a neighbourhood order to be used for constructing an extension of the differential risk hotspots. The summary is also given for the segments forming this extension}

\item{which.plot}{- A numeric vector indicating which differential risk hotspots to plot (according to the way they are ordered in \code{hotspots})}

\item{eps_image}{- If set to \code{TRUE}, an .eps image is generated. By default it is set to \code{FALSE}}
}
\description{
This function plots a set of differential risk hotspots located along a linear network. An extension of the hotspots (including the kth order neighbours of the segments of the hotspots) is also plotted
}
\examples{
library(DRHotNet)
library(spatstat.geom)
library(spatstat.linnet)
library(spdep)
library(raster)
rel_assault <- relpnet(X = chicago, 
lixel_length = 50, h = 50, mark = "marks", category_mark = "assault")
hotspots_assault <- drhot(X = chicago, rel_probs = rel_assault, 
k = 0.5, n = 4)
plothot(X = chicago, hotspots = hotspots_assault)
}
