% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat.R
\docType{data}
\name{dats}
\alias{dats}
\title{Simulated single-state CRT survival data}
\format{
A data frame with \code{n} rows and 8 variables:
\describe{
  \item{cluster}{Integer cluster identifier.}
  \item{id}{Integer individual identifier within cluster.}
  \item{trt}{Cluster-level treatment indicator; \code{0} = control,
    \code{1} = intervention. Constant within cluster.}
  \item{W1}{Cluster-level baseline binary covariate (e.g., center-level
    characteristic).}
  \item{W2}{Cluster-level baseline continuous covariate.}
  \item{Z1}{Individual-level continuous baseline covariate.}
  \item{Z2}{Individual-level binary baseline covariate.}
  \item{time}{Observed follow-up time (event or censoring time).}
  \item{event}{Event indicator; \code{1} = terminal event,
    \code{0} = right censored.}
}
}
\usage{
dats
}
\description{
A simulated cluster-randomized trial (CRT) dataset with a \emph{single}
terminal event type and right censoring. Each row corresponds to one
individual in a cluster. The data are intended for illustrating the
doubly-robust survival estimators in \pkg{DRsurvCRT} for the simple
two-state setting (alive vs. terminal event).
}
\details{
The dataset was generated from a cluster-randomized design with
covariate-dependent hazards and administrative censoring. It is primarily
used to demonstrate calls such as \code{DRsurvfit(..., estimand = "SPCE")}
and the corresponding variance and plotting methods in the single-state
setting.
}
\examples{
data(dats)

## quick look
head(dats)
table(dats$cluster, dats$trt)

## Example use with DRsurvfit (marginal Cox working model)
\donttest{
fit_spce <- DRsurvfit(
  data    = dats,
  formula = survival::Surv(time, event) ~ W1 + W2 + Z1 + Z2 + cluster(cluster),
  intv    = "trt",
  method  = "marginal",
  estimand = "SPCE",
  variance = "jackknife"
)

summary(fit_spce)
plot(fit_spce, level = "cluster")
}

}
\keyword{datasets}
