% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRsurvfit.R
\name{plot.DRsurvfit}
\alias{plot.DRsurvfit}
\title{Plot method for DRsurvfit objects (SPCE / RMT-IF)}
\usage{
\method{plot}{DRsurvfit}(
  x,
  level = c("cluster", "individual"),
  states = NULL,
  tau = NULL,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{x}{A \code{DRsurvfit} object.}

\item{level}{Character: \code{"cluster"} or \code{"individual"}.}

\item{states}{Optional integer vector of states to plot when
\code{estimand = "SPCE"}. Defaults to all states
\code{1:object$max_state}.}

\item{tau}{Optional numeric truncation time. If non-\code{NULL}, only
event times \code{<= max(tau)} are plotted. If \code{NULL}, all event
times are plotted.}

\item{alpha}{Nominal type I error for the intervals; coverage is
\code{1 - alpha}. Default is \code{0.05}.}

\item{...}{Unused; included for S3 consistency.}
}
\value{
The input object \code{x}, invisibly.
}
\description{
Produces plots for multi-state doubly-robust estimators:
\itemize{
  \item For \code{estimand = "SPCE"}: for each state \eqn{s}, plots the
        difference curve \eqn{S_{1,s}(t) - S_{0,s}(t)} with jackknife
        t-based confidence bands over time.
  \item For \code{estimand = "RMTIF"}: plots the overall RMT-IF difference
        curve \eqn{R_1(t) - R_0(t)} (sum of stage-wise contributions) with
        jackknife t-based confidence bands over time.
}

The argument \code{tau} is a truncation time: if supplied, the plot is
restricted to \code{event_time <= tau}. If \code{tau} is \code{NULL}, the
full event-time grid is used.
}
