% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_confint_fit.R
\name{simulate_confint_fit}
\alias{simulate_confint_fit}
\title{Fit a simple viral infection model and compute confidence intervals}
\usage{
simulate_confint_fit(
  U = 1e+05,
  I = 0,
  V = 10,
  n = 0,
  dU = 0,
  dI = 2,
  p = 0.01,
  g = 0,
  b = 0.01,
  blow = 1e-06,
  bhigh = 1000,
  dV = 2,
  dVlow = 0.001,
  dVhigh = 1000,
  iter = 20,
  nsample = 10,
  rngseed = 100,
  parscale = 1
)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{n}{: rate of uninfected cell production : numeric}

\item{dU}{: rate at which uninfected cells die : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{g}{: unit conversion factor : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{blow}{: lower bound for infection rate : numeric}

\item{bhigh}{: upper bound for infection rate : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{dVlow}{: lower bound for virus clearance rate : numeric}

\item{dVhigh}{: upper bound for virus clearance rate : numeric}

\item{iter}{: max number of steps to be taken by optimizer : numeric}

\item{nsample}{: number of samples for conf int determination : numeric}

\item{rngseed}{: seed for random number generator to allow reproducibility : numeric}

\item{parscale}{: 1 for linear, 2 for log space parameter fitting : numeric}
}
\value{
The function returns a list containing the best fit time series, the best fit parameters for
the data, the final SSR, and the bootstrapped 95 percent confidence intervals.
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The model describes a simple viral infection system.
}
\details{
A simple compartmental ODE model mimicking acute viral infection
is fitted to data.
Confidence intervals are computed by simple bootstrapping of the data
using the boot R package. Confidence intervals are computed using the
percentage method in boot.ci. See the boot package for more information.
This code is part of the DSAIRM R package.
For additional model details, see the corresponding app in the DSAIRM package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_confint_fit()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_confint_fit(iter = 5, nsample = 5)
}
