% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalSession.R
\name{dsStateMessage,OpalSession-method}
\alias{dsStateMessage,OpalSession-method}
\title{Get the remote R session state message}
\usage{
\S4method{dsStateMessage}{OpalSession}(session)
}
\arguments{
\item{session}{\code{\link{OpalSession-class}} object.}
}
\value{
A character string
}
\description{
Explain the remote R session state as a human-readable message.
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "administrator", "password", "https://opal-demo.obiba.org")
session <- dsSession(con, async = TRUE)
ready <- dsIsReady(session)
while (!ready) {
  Sys.sleep(1)
  ready <- dsIsReady(session)
  cat(dsStateMessage(session), "\n")
}
dsDisconnect(con)
}

}
