% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_artists_albums.R
\name{get_artist_albums}
\alias{get_artist_albums}
\title{Get Artist Albums}
\usage{
get_artist_albums(artist_name, album_type = "album", limit = 50,
  offset = 0, access_token = DSpoty::get_spotify_access_token())
}
\arguments{
\item{artist_name}{String of artist name.}

\item{album_type}{Character vector of album types to include. Valid values are "album", "single", "appears_on", and "compilation". Defaults to "album".}

\item{limit}{Integer indicating the max number of artists to return. Defaults to 50, max of 50.}

\item{offset}{Integer indicating the offset of the first artist to return. Defaults to 0 (Spotify's API default value).}

\item{access_token}{Spotify Web API token. Defaults to DSpoty::get_spotify_access_token()}
}
\value{
Returns a data frame with all the albums of the selected artist
}
\description{
This function returns an artist's discography on Spotify.
}
\examples{
\dontrun{
albums <- get_artist_albums('radiohead')
}
}
\author{
Alberto Almuiña
}
