% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_artist_tracks_features.R
\name{get_artist_tracks_features}
\alias{get_artist_tracks_features}
\title{Get Artist Tracks Features}
\usage{
get_artist_tracks_features(artist_name, limit = 100, offset = 0,
  access_token = DSpoty::get_spotify_access_token())
}
\arguments{
\item{artist_name}{String of an artist name}

\item{limit}{Integer indicating the max number of artists to return. Defaults to 100, max of 100.}

\item{offset}{Integer indicating the offset of the first artist to return. Defaults to 0 (Spotify's API default value).}

\item{access_token}{Spotify Web API token. Defaults to DSpoty::get_spotify_access_token()}
}
\value{
Returns a data frame with the tracks features for all the tracks of an artist
}
\description{
This function returns audio features for all the tracks of a given artist
}
\examples{
\dontrun{
tracks_features<-get_artist_tracks_features('Shakira')
}
}
\author{
Alberto Almui?a
}
