% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_artists_by_genre.R
\name{get_artists_by_genre}
\alias{get_artists_by_genre}
\title{Get Artists by Genre}
\usage{
get_artists_by_genre(genre = is.character(), offset = "0",
  limit = "10", year = 2019,
  access_token = DSpoty::get_spotify_access_token())
}
\arguments{
\item{genre}{String of genre name to search for}

\item{offset}{Integer indicating the offset of the first artist to return. Defaults to 0 (Spotify's API default value).}

\item{limit}{Integer indicating the max number of artists to return. Defaults to 10, max of 50.}

\item{year}{Year to search for}

\item{access_token}{Spotify Web API token. Defaults to DSpoty::get_spotify_access_token()}
}
\value{
Returns a data frame with the artist's information of a determined genre
}
\description{
Function to search artists by genre
}
\examples{
\dontrun{
rock_artists <- get_artists_by_genre("rock")
}
}
\author{
Alberto Almui?a
}
