% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spotify_item.R
\name{get_spotify_item}
\alias{get_spotify_item}
\title{Get Spotify Item}
\usage{
get_spotify_item(name = NULL, type, limit = 1, offset = 0,
  access_token = DSpoty::get_spotify_access_token(), artist = NULL,
  album = NULL)
}
\arguments{
\item{name}{String of item name (artist, album, track...). Default: NULL}

\item{type}{String of the search type. Possible values are 'artist', 'album' and 'track'.}

\item{limit}{Integer indicating the max number of artists to return. Defaults to 1, max of 50.}

\item{offset}{Integer indicating the offset of the first artist to return. Defaults to 0 (Spotify's API default value).}

\item{access_token}{Spotify Web API token. Defaults to DSpoty::get_spotify_access_token()}

\item{artist}{String of album's artist name. Default: NULL}

\item{album}{String of album name. Default: NULL}
}
\value{
Returns a data frame with the item's information
}
\description{
This function searches spotify item by name
}
\details{
You have two options to use this function: Search by parameter name or search by parameters artist + album. In this second case, type must always be 'album'.
}
\examples{
\dontrun{
get_spotify_item(name = 'Arctic Monkeys', type = 'artist')
get_spotify_item(artist = 'Leiva', album = 'Nuclear', type = 'album')
get_spotify_item(name = 'Do I Wanna Know?', type = 'track')
}
}
\author{
Alberto Almuiña
}
